const { ccclass, property } = cc._decorator;

@ccclass
export default class BlockItem extends cc.Component {

  isMove = false

  viewWidth = 0

  viewHeight = 0
  start() {
    this.viewHeight = cc.view.getVisibleSize().height
    this.viewWidth = cc.view.getVisibleSize().width
    this.addNodeEvent()
    const matrix = cc.find('blockMatrix', this.node.parent)
    const node = matrix.children[0]
    const k = node.convertToWorldSpaceAR(node.getPosition())
    console.log('start', k.x, k.y)
  }

  setBlockMatrixAll(parentPos: cc.Vec2) {
    this.isMove = false
    const allBlock = this.node.children
    allBlock.forEach((node: cc.Node) => {

    })
    const node = allBlock[0]
    const scripts = node.getComponent('block')
    // scripts.setBlockMatrix()
  }

  addNodeEvent() {
    this.node.on(cc.Node.EventType.TOUCH_START, () => {
      this.isMove = true
    }, this)

    this.node.on(cc.Node.EventType.TOUCH_END, () => {
      this.setBlockMatrixAll(this.node.getPosition())
    }, this)

    this.node.on(cc.Node.EventType.TOUCH_MOVE, (e: cc.Event.EventTouch) => {
      const allBlock = this.node.children
      const matrix = cc.find('blockMatrix', this.node.parent)
      const node = allBlock[0]

      const blockPos = node.convertToWorldSpaceAR(node.getPosition())
      console.log(blockPos.x, blockPos.y);
      console.log("========================")

      if (this.isMove) {
        const pos: cc.Vec2 = e.getPreviousLocation()
        const viewW = this.viewWidth, viewH = this.viewHeight
        
        this.node.setPosition(pos.x - (viewW / 2), pos.y - (812 - (1624 - viewH) / 2))
      }
    }, this)
  }

  // update (dt) {}
}
