import Svga from "./Components/Svga/Svga";
import { SvgaEvent } from "./Components/Svga/SvgaEvent";
import { CUSTOM_EVENT, Config, GameColors } from "./Config/GameConfig";
import exportEvent from "./exportEvent";
import { getProbability, getRandomArrayElements, loadGameResources, numToChinese, randomNum, getUrlParam } from "./utils";
const { ccclass, property } = cc._decorator;


@ccclass
export default class GameScene extends cc.Component {

  /** 游戏配置 */
  gameConfig = { ...Config }


  protected onLoad(): void {

    // loadGameResources()
    /** 开启碰撞检测 */
    const cm = cc.director.getCollisionManager()
    cm.enabled = true
    // cm.enabledDebugDraw = true;
  }

  start() {
    this.addNodeEvent()
  }

  /** 添加节点的事件 */
  addNodeEvent() {
    // cc.game.on(cc.game.EVENT_HIDE, () => {
    //   this.dateNow = Date.now()
    // })
    // cc.game.on(cc.game.EVENT_SHOW, () => {
    //   const difference = Date.now() - this.dateNow
    //   this.countDown = Math.max(0, this.countDown - Math.ceil(difference / 1000))
    //   this.dateNow = 0
    // })

    exportEvent.on(CUSTOM_EVENT.NEXT_LEVEL, this.nextLevel, this)
    exportEvent.on(CUSTOM_EVENT.GAME_START, this.startGame, this)
    exportEvent.on(CUSTOM_EVENT.GAME_INIT, ({ detail = {} }) => {
      this.resetConfig(detail)
    }, this)
    exportEvent.on(CUSTOM_EVENT.GAME_DESTROY, () => {
      this.node.destroy()
    }, this)
    // TODO 测试用
    const href = window?.location?.href
    const isTest = getUrlParam('testPanel')
    const testNode = cc.find('test', this.node)
    testNode.active = isTest
    if (isTest && (href?.includes('duibadev') || href?.includes('duibatest')) || href.includes('localhost')) {
      const testEventMap = {
        next: 'nextLevel',
        refreshProp: 'refreshStageProps',
        start: 'testStartGame',
        init: 'testInit',
      }
      testNode.children.forEach((n) => {
        const event = this?.[testEventMap[n.name]]
        n.on(cc.Node.EventType.TOUCH_END, event, this)
      })
    }
  }

  testStartGame() {
    console.log('测试')
    exportEvent.fire(CUSTOM_EVENT.GAME_START)
  }

  testInit() {
    console.log('测试初始化')
    exportEvent.fire(CUSTOM_EVENT.GAME_INIT, {
    })
  }

  /**
   * 开始游戏
   * @param config config
   */
  startGame({ detail = {} }) {
  }

  /**
   * 重置游戏配置
   * @param con 游戏配置
   */
  resetConfig(con = {}) {
    this.gameConfig = {
      ...Config,
      ...con
    }
  }

  /** 出钩 */
  playGame() {
    if (this.isGameOver || !this.isStartGame || this.clipAni) return
    this.setClipState(CLIP_STATE.PLAY)
  }

  /** 游戏结束 */
  gameOver() {
    this.isGameOver = true
    exportEvent.fire(CUSTOM_EVENT.GAME_OVER, {
    })
  }

  /**
   * 设置节点lable
   * @param value 
   */
  setLable(key, value) {
    cc.find(key, this.node).getComponent(cc.Label).string = value + ''
  }

  protected onDestroy(): void {
    this.unschedule(this.startCd)
  }

  /** 刷新关卡信息 */
  refreshLevelInfo(level = 0) {
  }

  /** 下一关 */
  nextLevel() {
  
  }

  /** 刷新舞台道具 */
  refreshStageProps() {
  
  }

  update(dt: number): void {
    if (this.isGameOver || !this.isStartGame) return
  }
}
