// Learn TypeScript:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/life-cycle-callbacks.html

import { BLOCK_STATE, Config } from "./Config/GameConfig";

const { ccclass, property } = cc._decorator;

@ccclass
export default class Block extends cc.Component {
  /** 方块状态 0空，1有方块填入 */
  blockState: BLOCK_STATE = BLOCK_STATE.EMPTY

  /** 动画 */
  ani:cc.Animation = null

  aniDuration = 0

  /** 方块动画播放速率 */
  speed = 0.9
  // onLoad () {}

  start() {
    // this.changeBlockState(BLOCK_STATE.EMPTY)
    this.ani = this.node.getComponent(cc.Animation)
    const animationState = this.ani.getAnimationState('blockBoom')
    this.aniDuration = animationState.duration
  }

  /** 播放清除动画 */
  playClearAni(cb) {
    const ani = this.ani
    const animationState = this.ani.getAnimationState('blockBoom')
    animationState.speed = this.speed
    ani.once('finished',() => {
      this.changeBlockState(BLOCK_STATE.EMPTY)
      cb?.()
    })
    ani.play()
  }

  /**
   * 修改当前方块状态
   * @param type 0 清空，1 填入方块
   */
  changeBlockState(type: BLOCK_STATE) {
    this.node.scale = 1
    this.blockState = type
    this.node.color = cc.color(type === BLOCK_STATE.NON_EMPTY ? Config.setBlockColor : Config.defaultColor)
  }

  // update (dt) {}
}
