// Learn TypeScript:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/life-cycle-callbacks.html

import { BLOCK_STATE, Config } from "./Config/GameConfig";
import propPool from "./propPool";

const { ccclass, property } = cc._decorator;

@ccclass
export default class Block extends cc.Component {
  /** 方块状态 0空，1有方块填入 */
  blockState: BLOCK_STATE = BLOCK_STATE.EMPTY

  // onLoad () {}

  start() {

  }

  /** 播放清除动画 */
  playClearAni(cb) {
    this.changeBlockState(BLOCK_STATE.EMPTY)
    // propPool.push()
  }

  /**
   * 修改当前方块状态
   * @param type 0 清空，1 填入方块
   */
  changeBlockState(type: BLOCK_STATE) {
    this.blockState = type
    this.node.color = cc.color(type === BLOCK_STATE.NON_EMPTY ? Config.miniBlockColor : Config.defaultColor)
  }

  // update (dt) {}
}
