import { SvgaPlayer } from "@spark/svgaplayer";
import API from "@src/api";
import store from "@src/store";
import modalStore from "@src/store/modal";
import { observer } from "mobx-react";
import React, { useEffect } from "react";
import { RES_PATH } from "../../../sparkrc";
import './openBox.less';

const OpenBox = () => {
  const { boxState } = store;
  let drawInfo = null;

  useEffect(() => {
    drawPrize();
  }, []);

  /** 进入抽奖 */
  const drawPrize = async () => {
    const res = await API.drawPrize({ drawType: boxState ? '1' : '2' });
    if (res && res.success) {
      drawInfo = res.data;
    } else {
      // 接口报错关闭弹窗
      setTimeout(() => {
        store.getHomeData();
        modalStore.closePop('OpenBox');
      }, 1000);
    }
  };

  /** 动画播放中 */
  const onProcess = async (currentFrame) => {
    // 抽奖请求结束关闭弹窗
    if (currentFrame >= 70 && drawInfo) {
      modalStore.closePop('OpenBox');
      modalStore.pushPop('Getprize', drawInfo);
    }
  };

  return <div className="openbox">
    {boxState ?
      <SvgaPlayer className="bigbox-svga" onProcess={onProcess} src={RES_PATH + 'svga/bigbox.svga'} /> :
      <SvgaPlayer className="smailbox-svga" onProcess={onProcess} src={RES_PATH + 'svga/smailbox.svga'} />}
         </div>;
};

export default observer(OpenBox);