/**
 * 活动主入口
 */
import React, { Component } from "react";
import ReactDOM from "react-dom";
import {observer} from 'mobx-react';
import "./app.less";
import store from './store/index';
import Modal from './modal/modal';
import './utils/checkWebp';  // webp检查
import '../MD'; // 埋点

import SwiperCore, { Autoplay } from 'swiper';
SwiperCore.use([Autoplay]);

// 此处为spark-cli动态生成
import LoadingDemo from "@src/pages/loadingDemo/loadingDemo";
import HomeDemo from "@src/pages/homeDemo/homeDemo";
import CircleTurntableDemo from "./pages/CircleTurntableDemo/CircleTurntableDemo";
import Collect from "./pages/Collect";
import SwiperC from "./pages/SwiperC";
import BetterList from "./pages/BetterList";


/**
 * 所有页面场景
 */
export const pageMap = {
  loading: <LoadingDemo />,
  homePage: <HomeDemo/>,
  CircleTurntableDemo:<CircleTurntableDemo />,
  Collect:<Collect/>,
  SwiperC:<SwiperC />,
  BetterList:<BetterList />
}

@observer
class App extends Component {
  async componentDidMount(){
    // 获取前端开发配置，依据项目需要，酌情添加 ！！！
    // await store.getFrontVariable(); 
  }
  render() {
    const { curPage  } = store;
    return (
      <div>
        {{...pageMap[curPage], props: {changePage: 'homePage'}}}
        <Modal />
      </div>
    );
  }
}

ReactDOM.render(<App />, document.getElementById("root"));
