import { Toast } from "@spark/ui";
import API from "@src/api"
import { addLoading } from "@src/utils/utils"

export default {
  /** 首页数据 */
  homeInfo:{},

  /** 是否处于活动状态 */
  isActivi() {
    const { actStartTime, actEndTime, currentTime } = this.homeInfo;
    if (currentTime < actStartTime) {
      Toast('活动未开始~', 2000, { hideOthers: true });
      return false;
    }
    if (currentTime >= actEndTime) {
      Toast('活动已结束~~', 2000, { hideOthers: true });
      return false;
    }
    return true;
  },

  /** 设置首页数据 */
  setHomeInfo(data){
    this.homeInfo = data
  },

  /** 获取首页数据 */
  async getHomeInfo(){
    addLoading(async () => {
      const res = await API.homeInfo()
      if(res && res.success) {
        this.setHomeInfo(res.data)
      }
    })
  }
}