/** 
 * 活动首页demo 开发自行修改或替换
 */

'use strict';
import React from 'react';
import { observer } from 'mobx-react';
import './homeDemo.less';
import store from '@src/store';
import { all_page } from '@src/utils/constants';
import Circel from '@src/components/Circel';
import DPlayer from 'dplayer';
import Barrage from '@src/components/barrage/barrage';

@observer
class HomeDemo extends React.Component {
  constructor(props) {
    super(props);
    this.ctx = React.createRef()
  }

  componentDidMount() {
    this.initVideo()
  }

  initVideo = () => {
    this.dp = new DPlayer({
      container: this.videoNode,
      video: {
        // eslint-disable-next-line @spark/best-practices/no-url-in-js
        url: 'https://yun.duiba.com.cn/polaris/2022_01_03%E5%8F%A3%E5%91%B3%E7%8E%8B%E6%96%B0%E6%98%A5%E7%A4%BC%E7%9B%92_%E7%BB%88%E7%89%88_15S.c1ea067c788b05c037b35f03820e822faa9f4604.mp4',
      },
      loop: true,
    });
    this.dp.on('play', () => {
      console.log('开始播放')
    })
    this.dp.on('pause', () => {
      console.log('暂停播放')
    })
  }

  toPage = (page) => {
    console.log('p', page)
    store.changePage(page)
  }

  render() {
    const config = {
      size: 300, // 绘制圆形的最大尺寸，宽=高
      borderWidth: 1, // 边框宽度
      borderColor: "#fff023", // 边框颜色
      outerColor: "#fff", // 最外层底圆颜色
      scheduleColor: "#fff023", // 进度条动画颜色
      fontColor: "#000", // 字体颜色
      ringColor: "#ffc720", // 进度条环形颜色
      innerColor: "", // 最内圆底色
      fontSize: 30, // 字号
      time: 15, // 动画时长s
      auto: false, // 自动开始
    }
    const barrageData = Array(10).fill('弹幕弹幕').map((_, i) => {
      return _ + i
    })
    return (
      <div className="homeDemo">
        <p>下方点击查看详情</p>
        {all_page.map(({ name, page }) => {
          console.log(name, page)
          return <div key={name + page}>
            <p onClick={() => this.toPage(page)}>{name}</p>
          </div>
        })}
        <div>
          <p>环形进度条:</p>
          <div className='test-btn-wrp'>
            <div className='start-btn' onClick={() => this.ctx.current.start()}>开始</div>
            <div className='stop-btn' onClick={() => this.ctx.current.stop()}>暂停</div>
          </div>
          <br />
          <Circel ref={this.ctx}
            className='Circel'
            config={config}
            onStart={() => console.log('开始')}
            onStop={() => console.log('停止')}
            onEnd={() => console.log('结束')} />
        </div>
        <div>
          <p>视频播放:</p>
          {/* <div className='test-btn-wrp'>
            <div className='start-btn' onClick={() => this.ctx.current.start()}>开始</div>
            <div className='stop-btn' onClick={() => this.ctx.current.stop()}>暂停</div>
          </div> */}
          <br />
          <div ref={node => this.videoNode = node} id="my-player" className="video-js"></div>
        </div>
        <div>
          <p>通用弹幕:</p>
          <br />
          <div className='barrage-wrp'>
            {/* TODO 没有数据不能渲染弹幕 */}
            {barrageData.length > 0 ? <Barrage
              num={2}
              data={barrageData}
              renderLine={(data) => {
                return <div className='bar-s'>{data}</div>
              }}
            /> : null}
          </div>
        </div>
      </div>
    );
  }
}

export default HomeDemo;
