import { observer } from "mobx-react";
import React, { useEffect, useRef } from "react";
import { CD_EVENTS_TYPE, CircelCountdown } from "./circel.js";
import './index.less'

/**
 * 返回在页面中真实的 px 值
 * @param {Number} designSize 设计稿上的像素值
 * @returns 
 */
function getTruthPx(designSize) {
  const remUnit = parseFloat(document.documentElement.style.fontSize)
  return designSize / 100 * remUnit
}

const Circel = React.forwardRef(({
  className,
  id = 'CircelCanvas',
  onStart,
  onEnd,
  onStop,
  config = {
    width: '300',
    heigth: '300',
    size: 130, // 绘制圆形的最大尺寸，宽=高
    borderWidth: 4, // 边框宽度
    borderColor: "#fff", // 边框颜色
    outerColor: "#fff", // 最外层底圆颜色
    scheduleColor: "#fff", // 进度条动画颜色
    fontColor: "#fff", // 字体颜色
    ringColor: "#ffc720", // 进度条环形颜色
    innerColor: "#4e84e5", // 最内圆底色
    fontSize: 10, // 字号
    time: 20, // 动画时长s
    auto: false, // 自动开始
  } }, ctd) => {

  useEffect(() => {
    init()
  }, [config])

  const init = () => {
    const settings = {
      id: id,         // ID，canvas一定要有ID属性
      size: getTruthPx(config.size),            // 绘制圆形的最大尺寸，宽=高
      borderWidth: getTruthPx(config.borderWidth),       // 边框宽度
      borderColor: config.borderColor,   // 边框颜色
      outerColor: config.outerColor,    // 最外层底圆颜色
      scheduleColor: config.scheduleColor, // 进度条动画颜色
      fontColor: config.fontColor,    // 字体颜色
      ringColor: config.ringColor, // 进度条环形颜色
      innerColor: config.innerColor,// 最内圆底色
      fontSize: getTruthPx(config.fontSize),
      time: config.time,
      auto: config.auto, // 自动开始
    }
    ctd.current = new CircelCountdown(settings);
    ctd.current.on(CD_EVENTS_TYPE.START, onStart)
    ctd.current.on(CD_EVENTS_TYPE.END, onEnd)
    ctd.current.on(CD_EVENTS_TYPE.STOP, onStop)
    ctd.current.init();
    console.log(ctd.current.eventsMap)
  }

  return <div className={"circel-wrp " + className}>
    <canvas className="circel-con" id={id}></canvas>
  </div>

})

export default observer(Circel)