import CollectAni from "@src/components/CollectAni/CollectAni";
import { observer } from "mobx-react";
import React from "react";
import { RES_PATH } from "../../../sparkrc";
import './index.less'

const Collect = () => {
  const showAin = () => {
    // 收集动效
    CollectAni.show({
      from: 'start', // 收集动画开始的节点的id
      to: 'end', // 收集动画结束的节点的id
      icon: RES_PATH + 'common/goldBean.png', // 收集动画图片路径
      width: 36, // 收集动画图片的宽
      height: 40, // 收集动画图片的高
      count: 3, // 收集动画的图片数量
      duration: 1000 // 收集动画总的持续时长
    }, async () => { // 动画结束后的回调方法
      console.log('结束')
    })
  }
  return <div className="collect-wrapper" onClick={showAin}>
    <div className="start" id="start">
      开始位置
    </div>
    <div className="end" id="end">
      结束位置
    </div>
  </div>
}

export default observer(Collect)