'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import store from '../../store/index';
import { CircleTurntable } from '@spark/circle-turntable'; // 引入圆形转盘组件
import { _throttle } from '@src/utils/utils.js';
import API from '../../api/index';

import './CircleTurntableDemo.less';

@observer
class CircleTurntableDemo extends React.Component {
  constructor(props) {
    super(props);
    this.isDraw = false;
  }

  async componentDidMount() {
    await store.drawPrizeHome(); // 调用接口，获取抽奖数据
  }

  handleApi = _throttle(async () => {
    
  })

  // 点击「抽奖」按钮
  onClickStartButton = _throttle(async () => {
    if (this.isDraw) {
      return
    }
    this.isDraw = true
    const { prizeInfo } = store;
    const totalDrawNum = prizeInfo?.freeLeftCount * 1 + prizeInfo?.myCreditsOrSpValue * 1; // 今日剩余抽奖次数
    if (totalDrawNum <= 0) {
      return
    }
    const { data, success } = await API.drawPrize(); // 调用抽奖接口
    if (success && data) {
      store.setDrawPrizeInfo(data); // 设置抽奖数据
      if (data?.options?.length > 0) {
        const selectedId = data?.options[0].optionId; // 抽中奖品的id
        this.ttRef.launch();
        const optionsIdArr = prizeInfo?.options?.map(_ => _.optionId); // 奖品id数组
        const selectedIndex = optionsIdArr.indexOf(selectedId); // 抽中奖品的索引值
        console.log("获奖的索引0-7", selectedIndex);
        // optionIndex: 最终落在奖项的索引 immediately: 是否立刻停止 randomOffset: 是否模拟随机角度偏移(效果更加真实)
        this.ttRef.braking(selectedIndex, { immediately: false, randomOffset: false });
      }
    }
  })

  // 抽奖结束回调
  onEnd = async () => {
    await store.drawPrizeHome(); // 刷新抽奖组件首页数据
    const { drawPrizeInfo } = store; // 抽奖数据
    if (drawPrizeInfo?.options?.length > 0) {
      const selectedId = drawPrizeInfo?.options[0].optionId; // 抽中奖品的id
      if (selectedId == "thanks") { // 未抽中奖
        console.log('未中奖')
      } else { // 抽中奖品
        console.log('中奖')
      }
    }
    setTimeout(() => {
      this.isDraw = false
    }, 1000)
  };

  render() {
    const { prizeInfo } = store;
    return (
      <div className="rotaryDraw">
        <div className="rotaryTableContent">
          {/* 圆形抽奖转盘 */}
          {
            prizeInfo?.options?.length > 0 &&
            <CircleTurntable
              className="turntable"
              ref={(e) => { this.ttRef = e }}
              options={prizeInfo?.options}
              angleOffset={20}
              radian={90}
              launchDuration={1000}
              brakingDuration={1000}
              maxSpeed={20}
              didStop={this.onEnd}
              renderBackground={<span className="bg" />}
              renderStartButton={
                // 「抽奖」按钮
                <div className="start-button" onClick={this.onClickStartButton}></div>
              }
              renderOption={(optionData, index) => {
                return (
                  <div className="option" key={index + "a"}>
                    <span className="option-name">{optionData.optionName}</span>
                    <img className="option-icon" src={optionData.optionImg} />
                  </div>
                );
              }}
            ></CircleTurntable>
          }
        </div>
      </div>
    );
  }
}
export default CircleTurntableDemo;
