export const CD_EVENTS_TYPE = {
  /** 开始 */
  START: 'START',
  /** 进行中 */
  PENDING: 'PENDING',
  /** 结束 */
  END: 'END',
  /** 停止 */
  STOP: 'STOP'
}

export class CircelCountdown {
  constructor(settings) {
    // 设置默认参数
    this.settings = {
      ...settings
    };
    // 步长
    this.schedule = 0
    /** 事件MAP */
    this.eventsMap = {}
    this.timer = null
    this.oldTime = null
    this.timeCopy = this.settings.time * 1000
    this.stopTime = 0
  }
  init(opt) {
    this.obj = document.getElementById(this.settings.id);
    this.obj.width = this.settings.size;
    this.obj.height = this.settings.size;
    this.ctx = this.obj.getContext("2d");
    extend(this.settings, opt);
    this.drawBackground();
    this.drawProcess();
    this.drawAnimate();
    this.drawInner();
    this.strokeText(0);
    this.settings?.auto && this.start();
  }
  // 绘制底色
  drawBackground() {
    this.drawCircle(0, 360, 0, this.settings.outerColor);
  }
  // 绘制进度条动画背景
  drawProcess() {
    this.drawCircle(0, 360, 4, this.settings.ringColor);
  }
  // 绘制倒计时
  drawInner() {
    this.drawCircle(0, 360, 23, this.settings.innerColor);
    this.strokeBorder(this.settings.borderWidth);
  }
  // 绘制进度条动画
  drawAnimate() {
    // 旋转的角度
    const deg = Math.PI / 180;
    const v = this.schedule * 360, startAng = -90, endAng = -90 + v;

    this.ctx.beginPath();
    this.ctx.moveTo(this.settings.size / 2, this.settings.size / 2);
    this.ctx.arc(this.settings.size / 2, this.settings.size / 2, this.settings.size / 2 - 3, startAng * deg, endAng * deg, false);
    this.ctx.fillStyle = this.settings.scheduleColor;
    this.ctx.fill();
    this.ctx.closePath();

  }
  // 绘制边框
  strokeBorder(borderWidth) {
    this.ctx.lineWidth = borderWidth;
    this.ctx.strokeStyle = this.settings.borderColor;
    this.ctx.stroke();
  }
  // 绘制文字
  strokeText(text) {
    this.ctx.textAlign = "center";
    this.ctx.textBaseline = "middle";
    this.ctx.font = this.settings.fontSize + "px" + " microsoft yahei";
    this.ctx.fillStyle = this.settings.fontColor;
    this.ctx.fillText(text, this.settings.size / 2, this.settings.size / 2);
  }
  // 绘制圆
  drawCircle(startAng, endAng, border, fillColor) {
    const deg = Math.PI / 180;
    this.ctx.beginPath();
    this.ctx.arc(this.settings.size / 2, this.settings.size / 2, this.settings.size / 2 - border, startAng * deg, endAng * deg, false);
    this.ctx.fillStyle = fillColor;
    this.ctx.fill();
    this.ctx.closePath();
  }
  // 进度条动画
  start() {
    if (!this.oldTime) {
      this.oldTime = +new Date();
    }
    if (this.stopTime) {
      this.oldTime += +new Date() - this.stopTime
    }
    const oldTime = this.oldTime
    this.emit(CD_EVENTS_TYPE.START)
    this.timer = setInterval(() => {
      const allMs = this.settings.time * 1000, // 如30*1000=30 000ms
        currentTime = +new Date();
      // 步长=（当前的时间-过去的时间）/总秒数
      const schedule = (currentTime - oldTime) / allMs;
      this.schedule = schedule;

      this.drawAll(schedule);
      if (currentTime - oldTime >= allMs) {
        // 重绘
        this.drawBackground();
        this.drawProcess();
        this.drawAnimate();
        this.drawInner();
        this.stop()
        this.emit(CD_EVENTS_TYPE.END)
      }
    }, 100);
  }
  // 停止
  stop() {
    this.stopTime = Date.now()
    this.emit(CD_EVENTS_TYPE.STOP)
    clearInterval(this.timer);
  }
  // 绘制所有
  drawAll(schedule) {
    schedule = schedule >= 1 ? 1 : schedule;
    const text = parseInt(this.settings.time * (1 - schedule)) + 1;
    // 清除画布
    this.ctx.clearRect(0, 0, this.settings.size, this.settings.size);
    this.drawBackground();
    this.drawProcess();
    this.drawAnimate();
    this.drawInner();
    this.strokeText(text);
  }
  // 绑定事件
  on(events, callback) {
    this.eventsMap[events] = callback
  }
  // 触发事件
  emit(events) {
    this.eventsMap?.[events]?.()
  }
}

// 对象拷贝
function extend(obj1, obj2) {
  for (const attr in obj2) {
    obj1[attr] = obj2[attr];
  }
}