import { md } from '@spark/utils'
// import { logExposure, logClick } from '@spark/utils/src-js/md';

const { appID: appId, projectId } = window['CFG']
const dcm = '202.' + projectId + '.0.0';
const domain = '//embedlog.duiba.com.cn';

md.prepare({ appId })
/** 单曝光 */
const exposure = []
/** 单点击 */
const click = []
/** 既曝光也点击 */
const all = []

const mdList = Array(24).fill('').map((_, index) => {
  const ci = index + 1
  return {
    ele: `.md${ci}`,
    data: {
      dpm: `${appId}.110.${ci}.1`,
      dcm,
    },
    logExposure: [...exposure, ...all].includes(ci),
    logClick: [...click, ...all].includes(ci)
  }
})
md.registerBuriedPoints(mdList);

// 曝光埋点方法
export function handleLogExposure(id, id2 = 1) {
  md.logExposure({
    dpm: `${appId}.110.${id}.${id2}`,
    dcm,
    domain,
    appId,
  })
}

// 点击埋点方法
export function handleLogClick(id, id2 = 1) {
  md.logClick({
    dpm: `${appId}.110.${id}.${id2}`,
    dcm,
    domain,
    appId,
  })
}