import { makeAutoObservable } from 'mobx';
import API from '../api/index';
import CircleTurntableDemo from './CircleTurntableDemo';

const store = makeAutoObservable({
    /** 活动规则 */ 
    ruleInfo: '',
    /** 前端开发配置 */ 
    frontVariable: {},  
    /** 当前页面 */ 
    curPage: 'homePage',
    /** 设置活动规则 */ 
    setRule(ruleInfo) {
        this.ruleInfo = ruleInfo
    },
    /** 场景切换 */ 
    changePage(page, callback) {
        this.curPage = page;
        callback && callback();
    },
    /** 获取活动规则 */ 
    async initRule() {
        // 模拟获取远程的数据
        const { data } = await API.getRule();
        this.setRule(data)
    },
    /** 获取前端配置项 */ 
    async getFrontVariable() {
        // 获取前端开发配置
        const { data } = await API.getFrontVariable();
        this.frontVariable = data || {};
        console.log('前端开发配置', data)
    },
    ...CircleTurntableDemo
})

export default store; 