import React from "react";
import { Swiper, SwiperSlide } from 'swiper/react';

import 'swiper/swiper.less';
import './index.less'

const SwiperC = () => {
  const prizeInfo = Array(12).fill(' ').map((_, i) => {
    return {
      "prizeName": "奖品名称奖品名称" + i,
      // eslint-disable-next-line @spark/best-practices/no-url-in-js
      "prizeUrl": "//yun.duiba.com.cn/aurora/assets/8e42586a6b47b99dde89e46c4740ad3e3e4ec98b.png"
    }
  })
  return (
    <Swiper
      className="prize-swiper"
      // spaceBetween={10}
      slidesPerView={3}
      // slidesOffsetAfter={65}
      autoplay={
        {
          delay: 3000,
          disableOnInteraction: false,
        }
      }
      initialSlide={0}
      // centerInsufficientSlides={prizeInfo.length <= 3}
      centeredSlidesBounds={true}
      observer
      loop={prizeInfo.length > 3}
    >
      {prizeInfo.length ?
        prizeInfo.map((item, index) => {
          const { prizeName,prizeUrl } = item || {}
          return (
            <SwiperSlide key={index + 'swiper-1'}>
              <div className="prize">
                <img className="bg-box" src={prizeUrl} alt=''></img>
                <span className="font"> {prizeName}</span>
              </div>
            </SwiperSlide>
          )
        }) : ""
      }

    </Swiper>)
}

export default SwiperC