"use strict";

import React from "react";
import { observer } from "mobx-react";
import "./activityRules.less";
import store from "@src/store";
import { _throttle } from "@src/utils/utils";
import modalStore from "@src/store/modal";

@observer
class ActivityRules extends React.Component {
    constructor(props) {
        super(props);
    }
    async componentDidMount() {
        await store.initRule();
    }
    render() {
        const { ruleInfo } = store;
        return (
            <div className="activityRules">
                <span className="bg21"></span>
                <span
                    className="activityRulesCopyLive"
                    dangerouslySetInnerHTML={{
                        __html: ruleInfo,
                    }}
                ></span>
                <span className="closeButton20" onClick = {_throttle(()=>{
                  modalStore.closePop("ActivityRules")
                })}></span>
            </div>
        );
    }
}
export default ActivityRules;
