import { IConfig, IRequestConfig, IRequestFn } from "@/typings/type";
import { request } from "@bytedance/mona-runtime";
import { getMockData } from "./mock";

export function miniRequest(config: IConfig): IRequestFn {
  const { requestType, envType, cloud, cloudName } = config;
  if (requestType !== "local") return h5RequestLocal?.({ cloud, cloudName });
  return mockRequest?.({ cloud, cloudName });
}

function mockRequest({}: IRequestConfig) {
  return async function <T = any>(
    apiName: string,
    params: Record<string, any> = {}
  ) {
    // console.log(
    //   `%c ---------- ${apiName} start ----------`,
    //   "color:green; font-weight:bold;"
    // );
    // const result = await getMockData(apiName);
    // console.log("result>>>", result);
    // console.log(
    //   `%c ---------- ${apiName} end ----------`,
    //   "color:green; font-weight:bold;"
    // );
    const url = `http://127.0.0.1:8890/${apiName}/`;

    console.log(
      `%c ---------- ${apiName} start ----------`,
      "color:green; font-weight:bold;"
    );
    let data: any;
    try {
      const res = await request({
        url: url,
        method: "GET",
        data: params,
        dataType: "json",
        header: {
          // "Content-Type": "application/json",
        },
      });
      data = res?.data || {};
      if (res.statusCode === 200 && !data.errcode) {
        data = {
          ...data,
          message: data?.desc,
        };
      } else {
        data = {
          success: false,
          code: data?.errcode,
          message: data?.desc,
          desc: data?.desc,
          data: null,
        };
      }
    } catch (error) {
      console.log(error);
      data = {
        success: false,
        message: `请稍后再试～`,
      };
    }

    console.log(
      `%c ---------- ${apiName} end ----------`,
      "color:green; font-weight:bold;",
      data
    );

    return data;
  };
}

function h5RequestLocal({}: IRequestConfig) {
  return async function <T = any>(
    apiName: string,
    params: Record<string, any> = {},
    httpType?: "GET" | "POST"
  ): Promise<T> {
    const { activityId, openId, data: _data, ...ext } = params;

    const url = `/apps/duiba/activity/${activityId}/api/${apiName}/`;

    console.log(
      `%c ---------- ${apiName} start ----------`,
      "color:green; font-weight:bold;"
    );
    let data: any;

    try {
      const res = await request({
        url,
        method: httpType || "POST",
        data: ext,
        dataType: "json",
        header: {
          // "Content-Type": "application/json",
        },
      });
      data = res?.data || {};
      if (res.statusCode === 200 && !data.errcode) {
        data = {
          ...data,
          message: data?.desc,
        };
      } else {
        data = {
          success: false,
          code: data?.errcode,
          message: data?.desc,
          desc: data?.desc,
          data: null,
        };
      }
    } catch (error) {
      data = {
        success: false,
        message: `请稍后再试～`,
      };
    }

    console.log(
      `%c ---------- ${apiName} end ----------`,
      "color:green; font-weight:bold;",
      data
    );

    return data;
  };
}
