import { IAuthInfo } from "@/typings/type";

export const onGetUserProfile = async (): Promise<IAuthInfo | false> => {
  return new Promise((resolve, reject) => {
    tt.getUserProfile({
      success: (res: any) => {
        console.log(res.userInfo);
        const { nickName, avatarUrl } = res.userInfo;
        resolve({ nickName, avatar: avatarUrl });
      },
      fail: (err: any) => {
        console.log("onGetUserProfile>>>err", err);
        resolve(false);
      },
    });
  });
};
