interface IAuthInfo {
  nickName: string;
  avatar: string;
}

interface IConfig {
  cloud?: any;
  cloudName: string;
  requestType: REQUEST_TYPE;
  envType: ENV_TYPE;
  mockUrl?: string;
}

export type IRequestFn = <T = any>(
  apiName: string,
  params?: Record<string, any>,
  httpType?: "GET" | "POST"
) => Promise<IResult<T>>;

interface IRequestConfig<T = any> {
  cloud: T;
  cloudName: string;
  mockUrl?: string;
}

type IResult<T = any> = IErrorResult | ISuccessResult<T>;

interface IProjectConfig {
  env: "test" | "pre" | "online"; // 云函数环境 test 测试环境 pre 预发环境 online 线上环境
  requestType: "local" | "yapi" | "cloud" | "tornado" | "h5" | "jst"; // cloud: 云函数, yapi: yapi 接口, local: 本地mock, tornado: 风驰台接口 h5 接口 jst 云应用
  cloudName: string; // 主云函数项目名 （若为运用，则填写相应的 cloudAppId）
  projectName: string; // 项目名称
  sellerId: string; // sellerId
  venderId: string; // h5 分享使用
  shopId: string; // 店铺id
  appKey: string; // h5 分享使用
  h5API: string; // h5API地址
  activityUrl: string; // 活动地址 h5分享使用
  tornadoAPI: string; // 新增：当requestType: 'tornadoAPI'时，找服务端提供地址
  defaultActivityId: string; // 默认活动id
}
