declare namespace GetUserInfo {
    interface Params {
        activityId: string
    }

    interface Res {
        user?: IUserInfo
        task?: ITaskInfo
        game?: IGameInfo
        card?: ICardInfo
        awards?: IAwardInfo
    }
}

interface IUserInfo {
    userNick: string
    avatar: string
    ticket: number
    member: {
        flag: boolean
        newMember?: boolean
        bememberTime?: number
        bememberDay?: string
    }
}

interface ITaskInfo {
    remainTimes: {
        [key: string]: number
    },
    lastLimit?: {
        [key: string]: number
    }
}

interface IGameInfo {
    game: {
        [key: string]: {
            isFirstGame: boolean
            gameTimes: number
            todayGameTimes: number
        }
    }
}

interface ICardInfo {
    card: {
        [key: string]: {
            useDrawTimes: number
            cardTotal: number
            resultantNum: number
            drawTimes: number
            cardInfo: {
                [key: string]: number
            }
        }
    }
}

interface IAwardInfo {
    drawTimes: {
        [key: string]: {
            fixed: number,
        }
    }
    exchangeValue?:{
        [key: string] : number
    }   //当前拥有的积分
    alreadyExchange?:{  //已经兑换的次数
        [key: string] : number
    }
    rankValue?: {
        [key: string]: {
            fixed: {
                value: number
            }
        }
    }
}