declare namespace GetExchangeList {
    interface Params {
        activityId?:string
    }

    interface Res {
        list:Array<IExchangeItem>
    }
}



interface IExchangeItem {
    image:string
    name:string
    type:number
    exchangeNum:number //需要的兑换积分
    limitNum:number      //兑换限制数量
    limitType:number     //兑换限制类型：单个商品 每日限制，总量限制
    id:string
    useStock:number     //剩余库存
    status?:number
    _id?:string
    ename?:string
    switchStock?:number  //库存类型：2不限库存/1限制库存
    stock?:number
    benefitType?:number
}

type IExchange = {
    modalType:number // 弹窗类型 关闭/确认/成功/失败
    modalInfo?:{
        confirmGoods?:IExchangeItem
        exchangeSuc?:ExchangePrize.Res
        exchangeFail?:ExchangePrize.Res
        // [key:string]: (IExchangeItem | ExchangePrize.Res)
    }
}
