import { Button, View, login } from '@bytedance/mona-runtime'
import React, { FC } from 'react'
import Wrapper from '@/components/Wrapper';
import { onGetUserProfile } from '@/utils'
import './index.less'
import { IAuthInfo } from '@/typings/type';

/** 用户授权组件属性 */
type IProps = {
  type?: 'user' | 'phone'
  /** 授权成功回调 */
  onSuccess?: (info: IAuthInfo | string) => void
}

const clspreFix = 'login-pancel-box'

export const LoginPancel: FC<IProps> = (props) => {
    const { onSuccess, type = 'user' } = props

    const onGetPhone = async (e?: any) => {
      login()
      return onSuccess && onSuccess(e?.detail?.iv || '')
    }

    const onGetUserInfo = async () => {
      const res = await onGetUserProfile()
      if(res) return onSuccess && onSuccess(res)
    }
    return (
      <Wrapper>
        <View className={clspreFix}>
          {type === 'phone'? <Button onGetPhoneNumber={(e) => onGetPhone(e)} className={`${clspreFix}__btn`} openType="getPhoneNumber">{'获取手机号'}</Button> : 
          <Button className={`${clspreFix}__btn`} onTap={() => onGetUserInfo()}>登录</Button>}
        </View>
      </Wrapper>
    )
}