import {
  PerspectiveCamera,
  Scene,
  AmbientLight,
  Mesh,
  BlinnPhongMaterial,
  SphereGeometry,
  Stage,
  PBRMaterial,
  CubeGeometry,
  Script,
  TinoeEventType,
} from "tinoe";
import { Texture2DLoader } from "@tinoe/glk";

export default async function init(stage: Stage) {
  /** 创建场景  */
  const scene = new Scene();

  /** 创建相机，并将相机加入到场景中  */
  const camera = new PerspectiveCamera({
    position: [0, 0, 2], // 位置
    aspectRatio: stage.canvas.clientWidth / stage.canvas.clientHeight, // 宽高比
  });
  scene.cameraManager.addCameras(camera);

  /** 创建光源，并将光源加入到场景中  */
  const ambientLight = new AmbientLight({
    color: "#fff", //光的颜色
  });
  scene.lightManager.addLights(ambientLight);

  /** 5. 创建3D地球 */
  // 创建球形几何体
  const geom = new SphereGeometry();

  // 创建材质
  const mat = new BlinnPhongMaterial();
  // 加载并上传地球纹理贴图
  mat.diffuseTexture = await Texture2DLoader.load(
    "https://s3-us-west-2.amazonaws.com/s.cdpn.io/141228/earthmap1k.jpg"
  );

  // 创建地球，并将其加入到场景中
  const earth = new Mesh(geom, mat);
  scene.addChildren(earth);
  console.log(earth);
  const scene2 = new Scene();
  const camera2 = new PerspectiveCamera({
    position: [0, 0, 4], // 位置
    aspectRatio: 1, // 宽高比
  });
  scene2.cameraManager.addCameras(camera2);
  scene2.lightManager.addLights(ambientLight);
  scene2.addChildren(new Mesh(new CubeGeometry(), new PBRMaterial({})));

  /** 启动渲染绘制 */
  stage.loop(() => {
    // stage.engine.enableBufferClear();
    // stage.setViewport(0, 0, stage.canvas.clientWidth / 2, stage.canvas.clientHeight);
    stage.run(scene);
    // stage.engine.disableBufferClear();
    // stage.setViewport(stage.canvas.clientWidth / 2, 0, stage.canvas.clientWidth / 2, stage.canvas.clientHeight);
    // stage.run(scene2);
  });

  scene.on(TinoeEventType.CLICK, (ev) => {
    console.log(ev.target);
  });

  scene2.on(TinoeEventType.CLICK, (ev) => {
    console.log(ev.target);
  });

  stage.enableControl();

  /** 添加动画效果 */
  scene.scriptManager.addUpdater((dt: number) => {
    earth.rotateY(dt * 10);
  });
}
