// Copyright 2022 Bytedance Inc.
// SPDX-License-Identifier: MIT
import {
  PerspectiveCamera,
  AmbientLight,
  DirectLight,
  Stage,
  Scene,
} from "tinoe";
import { GLTFLoader, AnimationManager } from "@tinoe/glk";
import { modelList } from "./constant";

export default async function init(stage: Stage) {
  if (!stage) return;

  const scene = new Scene(); // await GLTFLoader.loadAsScene(modelList[2]);
  // scene.background.setValue('#aaa');

  const camera = new PerspectiveCamera({
    position: [0, 0, 50],
    target: [0, 0, 0],
    aspectRatio: stage.canvas.width / stage.canvas.height,
  });
  //camera.position.set(0, 2.2, 15);
  scene.cameraManager.addCameras(camera);

  /** 创建光源，并将光源加入到场景中  */
  const ambientLight = new AmbientLight({
    color: "#fff", //光的颜色
  });
  scene.lightManager.addLights(ambientLight);

  const model = await GLTFLoader.load(modelList[0]);

  const animationManager = scene.addPlugin(AnimationManager);
  return { scene, animationManager };
}
