/** @format */
'use strict'

import React from 'react'
import { FC, useEffect } from 'react'
import {  createSelectorQuery, Canvas, View  } from '@bytedance/mona-runtime'
import { Stage,  } from 'tinoe'
import games from './utils'

import games2 from './model'

import './index.less'

const clsPreFix = 'canvas-pancel-box'

export const CanvasPance: FC = () => {

  useEffect(() => {
    createSelectorQuery().select('#myCanvas').node(res => {
      console.log(res)
    }).exec(res => {
      const canvas = res[0].node
      console.log('canvas--->',canvas?.width,canvas?.height)
      const stage = new Stage({ canvas })
      console.log('stage--->',stage)
      getLoader(stage)
    })
    // const canvas = document.getElementById('myCanvas')
    // if(!canvas) return;
    // const stage = new Stage({ canvas })
    // console.log('stage--->',stage, Stage.platform.createImage())
    // getLoader(stage)
  },[])

  const getLoader = async(stage: Stage) => {
    // const model = await GLTFLoader.
    await games(stage)
  }

  return(
    <View className={clsPreFix}>
      <Canvas id="myCanvas" canvasId="myCanvas" type="webgl" className={clsPreFix} />
    </View>
  )
}
