import { miniRequest } from "@/utils";
import config from "@/config";
import { IResult } from "./typings/type";

type Params = Record<string, any>;

export type TRequest = (params?: Params) => Promise<IResult<any>>;

const { cloudName, requestType } = config;

const request = miniRequest({
  cloudName,
  envType: process.env.MONA_TARGET,
  requestType,
});

export const login = (params: Login.Params) =>
  request<Login.Res>("login", params);
