const express = require("express");
const fs = require("fs");
const path = require("path");

const app = express();

const appPath = path.join(__dirname, "..", "mock");

const defaultPluginOptions = {
  port: 8890,
  host: "127.0.0.1",
};

console.log(appPath);

// post请求体相关
const bodyParser = require("body-parser");
app.use(bodyParser.json());

// 允许跨域
app.all("*", function (req, res, next) {
  res.header("Access-Control-Allow-Origin", "*");
  res.header("Access-Control-Allow-Methods", "PUT, GET, POST, DELETE, OPTIONS");
  // 此处根据前端请求携带的请求头进行配置
  res.header(
    "Access-Control-Allow-Headers",
    "Content-Type, Content-Length, Authorization, Accept, X-Requested-With , yourHeaderFeild"
  );
  if (req.method == "OPTIONS") {
    res.send(200);
  } else {
    next();
  }
});

app.get("*", function (req, res) {
  if (req.path !== "/favicon.ico") {
    const path = req.path.split("/")[1];
    console.log(path, "path>>>");

    const _data = fs.readFileSync(`${appPath}/${path}.js`, "utf-8");
    const real = _data.replace("export default", "");
    const _res = eval("(" + real + ")");
    res.json(_res);
  }
});

app.listen(defaultPluginOptions.port, () => {
  console.log(`监听端口 ${defaultPluginOptions.port}`);
});
