const path = require('path')
const gulp = require('gulp')
const gulpClean = require('gulp-clean')
const gulpLess = require('gulp-less')
const gulpRev = require('gulp-rev')
const gulpRevreplace = require('gulp-rev-replace')
const gulpUglify = require('gulp-uglify')
const gulpCsso = require('gulp-csso')
const pump = require('pump')
const browserSync = require('browser-sync').create()
const runSequence = require('run-sequence')
const rollup = require('rollup')
const rollupCommonjs = require('rollup-plugin-commonjs')
const rollupNoderesolve = require('rollup-plugin-node-resolve')
const rollupBabel = require('rollup-plugin-babel')
const TuiaAutoUpload = require('tuia-auto-upload')
const pluginDir = './src/' // 插件库目录
const outputPath = './dist/'
const tmpPath = './.tmp/'
const uploadPath = '/jimu-web/plugin/'
let pluginName
let pluginPath

const rollupBundle = name => {
  return async cb => {
    const bundle = await rollup.rollup({
      input: `${pluginPath}/${name}.js`,
      plugins: [
        rollupNoderesolve({
          jsnext: true,
          main: true
        }),
        rollupBabel({
          exclude: ['node_modules/**']
        }),
        rollupCommonjs({
          include: ['node_modules/**']
        })
      ]
    })

    await bundle.write({
      file: `${outputPath}${name}.js`,
      format: 'iife',
      sourcemap: true
    })
  }
}

// clean bundle
gulp.task('bundle:clean', cb => {
  return gulp.src([outputPath, tmpPath])
    .pipe(gulpClean())
})

// bundle vendor and plugin style
gulp.task('bundle:style', cb => {
  return gulp.src([`${pluginPath}/*.less`])
    .pipe(gulpLess())
    .pipe(gulp.dest(outputPath))
})

// bundle statuc
gulp.task('bundle:static', cb => {
  gulp.src([`${pluginPath}/index.html`])
    .pipe(gulp.dest(outputPath))

  gulp.src([`${pluginPath}/static/**`])
    .pipe(gulp.dest(`${outputPath}static`))

  cb()
})

// bundle vendor
gulp.task('bundle:vendor', rollupBundle('vendor'))

// bundle plugin
gulp.task('bundle:plugin', rollupBundle('plugin'))

// bundle init
gulp.task('bundle:init', ['bundle:clean'], cb => {
  pluginName = 'pluginA'
  pluginPath = pluginDir + pluginName
  cb()
})

// bundle
gulp.task('bundle', ['bundle:init'], cb => {
  runSequence(['bundle:style', 'bundle:static', 'bundle:vendor', 'bundle:plugin'], cb)
})

// bundle rev
gulp.task('bundle:rev', cb => {
  return gulp.src([`${outputPath}**/*`, `!${outputPath}/**/*.js.map`, `!${outputPath}index.html`])
    .pipe(gulpRev())
    .pipe(gulp.dest(tmpPath))
    .pipe(gulpRev.manifest())
    .pipe(gulp.dest(outputPath))
})

// bundle replace 
gulp.task('bundle:replace', cb => {
  let manifest = gulp.src(outputPath + 'rev-manifest.json')
  return gulp.src([`${tmpPath}**/*.js`, `${tmpPath}**/*.css`])
    .pipe(gulpRevreplace({
      manifest,
      prefix: `//yun.tuisnake.com${uploadPath}`
    }))
    .pipe(gulp.dest(tmpPath))
})


// bundle beautiful
gulp.task('bundle:beautify', cb => {
  gulp.src([`${tmpPath}**/*.js`])
    .pipe(gulpUglify())
    .pipe(gulp.dest(tmpPath))

  gulp.src([`${tmpPath}**/*.css`])
    .pipe(gulpCsso())
    .pipe(gulp.dest(tmpPath))

  cb()
})

// bundle upload
gulp.task('build:upload', cb => {
  const uploader = new TuiaAutoUpload({
    dir: path.join(__dirname, `${tmpPath}`),
    originDir: uploadPath
  })

  uploader.start()
})

// preview plugin
gulp.task('preview', ['bundle'], cb => {
  gulp.watch(`${pluginPath}/*.less`, ['bundle:style'])
  gulp.watch(`${pluginPath}/vendor.js`, ['bundle:vendor'])
  gulp.watch(`${pluginPath}/plugin.js`, ['bundle:plugin'])

  browserSync.init({
    watch: true,
    server: {
      baseDir: outputPath
    }
  })

  cb()
})

// build plugin
gulp.task('build', ['bundle'], cb => {
  runSequence(['bundle:rev'], ['bundle:replace'], ['bundle:beautify'], ['build:upload'], cb)
})