package cn.com.duiba.mysql.generator;

import cn.com.duiba.mysql.generator.entity.GeneratorConfig;

public class CodeGeneratorTest {

	public static void main(String[] args) {

		String DB_URL = "jdbc:mysql://localhost:3306/test?createDatabaseIfNotExist=true&useUnicode=true&characterEncoding=UTF-8&zeroDateTimeBehavior=convertToNull&allowMultiQueries=true&connectTimeout=5000&socketTimeout=60000";
		String user = "root";
		String pwd = "1234567890";

		GeneratorConfig config = new GeneratorConfig(DB_URL, user, pwd);
		config.setDaoPackage("cn.com.duiba.mysql.generator.test.dao");
		config.setEntityPackage("cn.com.duiba.mysql.generator.test.entity");
		config.setXmlLocation("src/main/resources/mappers");

		config.setServiceLocation("cn.com.duiba.mysql.generator.test.service");
		config.setServiceImplLocation("cn.com.duiba.mysql.generator.test.service.impl");
		config.setDtoPackage("cn.com.duiba.mysql.generator.test.dto");
		config.setRemotePackage("cn.com.duiba.mysql.generator.test.remote");
		config.setRemoteImplLocation("cn.com.duiba.mysql.generator.test.remoteimpl");
		config.setVoLocation("cn.com.duiba.mysql.generator.test.vo");

		config.setTableSchema("test");
		config.setTableName("tb_test");
		config.setTablePrefix("tb");
		config.setModuleName("");

		MybatisGenerator.genCode(config);
	}


}
