package cn.com.duiba.mysql.generator.gencode;

import cn.com.duiba.mysql.generator.entity.GeneratorConfig;
import cn.com.duiba.mysql.generator.entity.TableEntity;
import cn.com.duiba.mysql.generator.service.DuibaFreemarkerService;
import cn.com.duiba.mysql.generator.utils.PathUtils;

public class JavaRemoteServiceInterfaceImplGenerator extends AbstractGenerator{

	public JavaRemoteServiceInterfaceImplGenerator(DuibaFreemarkerService freemarkerService, TableEntity tableEntity, GeneratorConfig config) {
		super(freemarkerService, tableEntity, config);
	}

	@Override
	public String getFTL() {
		return "java_remote_service.impl";
	}

	@Override
	public String genFileName() {
		return "Remote"+tableEntity.getClassName() + "ServiceImpl.java";
	}

	@Override
	protected String genFilePath() {
		return PathUtils.getPathByPackage(config.getRemoteImplLocation(), config);
	}
}
