package cn.com.duiba.mysql.generator.gencode;

import cn.com.duiba.mysql.generator.entity.GeneratorConfig;
import cn.com.duiba.mysql.generator.entity.TableEntity;
import cn.com.duiba.mysql.generator.service.DuibaFreemarkerService;
import cn.com.duiba.mysql.generator.utils.PathUtils;

public class JavaServiceInterfaceGenerator extends AbstractGenerator{

	public JavaServiceInterfaceGenerator(DuibaFreemarkerService freemarkerService, TableEntity tableEntity, GeneratorConfig config) {
		super(freemarkerService, tableEntity, config);
	}

	@Override
	public String getFTL() {
		return "java_service";
	}

	@Override
	public String genFileName() {
		return tableEntity.getClassName() + "Service.java";
	}

	@Override
	protected String genFilePath() {
		return PathUtils.getPathByPackage(config.getServiceLocation(), config);
	}
}
