package cn.com.duiba.mysql.generator.entity;

import cn.com.duiba.mysql.generator.MybatisGenerator;
import cn.com.duiba.mysql.generator.exceptions.DuibaGeneratorException;
import lombok.Data;
import org.apache.commons.lang.StringUtils;

import java.sql.Connection;

/**
 * 代码生成器配置类
 */
//@Data
public class GeneratorConfig {

	/**
	 * 表名称 前缀，例如tb_activity, tb为前缀
	 */
	private String tablePrefix;

	/**
	 * 数据库连接
	 */
	private Connection connection;

	/**
	 * 要生成代码的表名称
	 */
	private String tableName;

	/**
	 * table_schema,表所在的库名称
	 */
	private String tableSchema;

	/**
	 * dao的包名
	 */
	private String daoPackage;

	/**
	 * Mybatis的xml的相对路径，相对于src/main/resources
	 */
	private String xmlLocation;

	/**
	 * entity包名,要生成的数据库对应实体包名
	 */
	private String entityPackage;

	/**
	 * entity包名,要生成的数据库对应实体包名
	 */
	private String dtoPackage;

	/**
	 * 模块名称
	 */
	private String moduleName;

	/**
	 * 模块名称
	 */
	private String apiModuleName;

	/**
	 * true:以测试用例执行生成代码的方式
	 */
	private boolean exeTest = true;

	/**
	 * true:以测试用例执行生成代码的方式
	 */
	private boolean needWebFile = false;

	/**
	 * true:以测试用例执行生成代码的方式
	 */
	private String remotePackage;

	/**
	 * true:以测试用例执行生成代码的方式
	 */
	private String remoteImplLocation;

	/**
	 * true:以测试用例执行生成代码的方式
	 */
	private String serviceLocation;

	/**
	 * true:以测试用例执行生成代码的方式
	 */
	private String serviceImplLocation;

	/**
	 * true:以测试用例执行生成代码的方式
	 */
	private String voLocation;

	/**
	 * true:以测试用例执行生成代码的方式
	 */
	private String controllerLocation;

	public GeneratorConfig(String dtoPackage) {
		this.dtoPackage = dtoPackage;
	}

	public GeneratorConfig(String dbUrl, String dbUserName, String dbPasswd) {
		this.connection = MybatisGenerator.getConnection(dbUrl, dbUserName, dbPasswd);
	}

	public void check() {
		if (connection == null) {
			throw new DuibaGeneratorException("connect to mysql failed");
		}
		if (StringUtils.isEmpty(tableName)) {
			throw new DuibaGeneratorException("tableName is null");
		}
		if (StringUtils.isEmpty(daoPackage)) {
			throw new DuibaGeneratorException("daoPackage is null");
		}
		if (StringUtils.isEmpty(entityPackage)) {
			throw new DuibaGeneratorException("DOpackage is null");
		}
		if (StringUtils.isEmpty(xmlLocation)) {
			throw new DuibaGeneratorException("xmlLocation is null");
		}
		if(needWebFile){
			if (StringUtils.isEmpty(remotePackage)) {
				throw new DuibaGeneratorException("remotePackage is null");
			}
			if (StringUtils.isEmpty(remoteImplLocation)) {
				throw new DuibaGeneratorException("remoteImplLocation is null");
			}
			if (StringUtils.isEmpty(serviceLocation)) {
				throw new DuibaGeneratorException("serviceLocation is null");
			}
			if (StringUtils.isEmpty(serviceImplLocation)) {
				throw new DuibaGeneratorException("serviceImplLocation is null");
			}
		}

	}


	public String getApiModuleName() {
		return apiModuleName;
	}

	public void setApiModuleName(String apiModuleName) {
		this.apiModuleName = apiModuleName;
	}

	public String getTablePrefix() {
		return tablePrefix;
	}

	public void setTablePrefix(String tablePrefix) {
		this.tablePrefix = tablePrefix;
	}

	public Connection getConnection() {
		return connection;
	}

	public void setConnection(Connection connection) {
		this.connection = connection;
	}

	public String getTableName() {
		return tableName;
	}

	public void setTableName(String tableName) {
		this.tableName = tableName;
	}

	public String getTableSchema() {
		return tableSchema;
	}

	public void setTableSchema(String tableSchema) {
		this.tableSchema = tableSchema;
	}

	public String getDaoPackage() {
		return daoPackage;
	}

	public void setDaoPackage(String daoPackage) {
		this.daoPackage = daoPackage;
	}

	public String getXmlLocation() {
		return xmlLocation;
	}

	public void setXmlLocation(String xmlLocation) {
		this.xmlLocation = xmlLocation;
	}

	public String getEntityPackage() {
		return entityPackage;
	}

	public void setEntityPackage(String entityPackage) {
		this.entityPackage = entityPackage;
	}

	public String getDtoPackage() {
		return dtoPackage;
	}

	public void setDtoPackage(String dtoPackage) {
		this.dtoPackage = dtoPackage;
	}

	public String getModuleName() {
		return moduleName;
	}

	public void setModuleName(String moduleName) {
		this.moduleName = moduleName;
	}

	public boolean isExeTest() {
		return exeTest;
	}

	public void setExeTest(boolean exeTest) {
		this.exeTest = exeTest;
	}

	public boolean isNeedWebFile() {
		return needWebFile;
	}

	public void setNeedWebFile(boolean needWebFile) {
		this.needWebFile = needWebFile;
	}

	public String getRemotePackage() {
		return remotePackage;
	}

	public void setRemotePackage(String remotePackage) {
		this.remotePackage = remotePackage;
	}

	public String getRemoteImplLocation() {
		return remoteImplLocation;
	}

	public void setRemoteImplLocation(String remoteImplLocation) {
		this.remoteImplLocation = remoteImplLocation;
	}

	public String getServiceLocation() {
		return serviceLocation;
	}

	public void setServiceLocation(String serviceLocation) {
		this.serviceLocation = serviceLocation;
	}

	public String getServiceImplLocation() {
		return serviceImplLocation;
	}

	public void setServiceImplLocation(String serviceImplLocation) {
		this.serviceImplLocation = serviceImplLocation;
	}

	public String getVoLocation() {
		return voLocation;
	}

	public void setVoLocation(String voLocation) {
		this.voLocation = voLocation;
	}

	public String getControllerLocation() {
		return controllerLocation;
	}

	public void setControllerLocation(String controllerLocation) {
		this.controllerLocation = controllerLocation;
	}
}
