package ${serviceLocation}.impl;

import ${serviceLocation}.${table.className}Service;
import ${dtoPackage}.${table.className}Dto;
import ${daoPackage}.${table.className}Dao;
import ${entityPackage}.${table.className}Entity;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.api.bo.page.PageQuery;
import java.util.Map;
import java.util.Date;


@Service
public class ${table.className}ServiceImpl implements ${table.className}Service{

    private static final Logger logger = LoggerFactory.getLogger(${table.className}ServiceImpl.class);

    @Autowired
    private ${table.className}Dao ${table.classname}Dao;


    @Override
    public Integer save(${table.className}Dto ${table.classname}Dto){
        return ${table.classname}Dao.save(BeanUtils.copy(${table.classname}Dto, ${table.className}Entity.class));
    }

<#if pk??>
    @Override
    public void deleteBy${pk.attrName}(${pk.attrType} ${pk.attrname}){
         ${table.classname}Dao.deleteBy${pk.attrName}(${pk.attrname});
    }

    @Override
    public void deleteBatchBy${pk.attrName}s(List<${pk.attrType}> ${pk.attrname}s){
         ${table.classname}Dao.deleteBatchBy${pk.attrName}s(${pk.attrname}s);
    }

    @Override
    public Integer updateBy${pk.attrName}(${table.className}Dto ${table.classname}Dto){
        return ${table.classname}Dao.updateBy${pk.attrName}(BeanUtils.copy(${table.classname}Dto, ${table.className}Entity.class));
    }

    @Override
    public ${table.className}Dto getBy${pk.attrName}(${pk.attrType} ${pk.attrname}){
        return BeanUtils.copy(${table.classname}Dao.getBy${pk.attrName}(${pk.attrname}), ${table.className}Dto.class);
    }

    @Override
    public Page<${table.className}Dto> findByPage(Map<String, Object> paramMap,PageQuery page) {
        Integer totalTotal = ${table.classname}Dao.findCountByCondition(paramMap);
        Page<${table.className}Dto> result = new Page<>();
        result.setPageNo(pageQuery.getPageNo());
        result.setPageSize(pageQuery.getPageSize());
        if(totalTotal == 0){
            result.setTotalCount(0);
            result.setTotalPages(0);
            result.setList(Lists.newArrayList());
            return result;
        }
        List<${table.className}Dto> data = BeanUtils.copyList(${table.classname}Dao.findByCondition(paramMap,pageQuery), ${table.className}Dto.class);
        int totalPages = count % pageQuery.getPageSize() > 0 ? count / pageQuery.getPageSize() + 1 : count / pageQuery.getPageSize();
        result.setTotalCount(count);
        result.setTotalPages(totalPages);
        result.setList(data);
        return result;
    }



</#if>
    <#list uks?keys as key>
        @Override
        public ${table.className}Dto getBy${key}(<#assign idx=0><#list uks[key] as uk>${uk.attrType} ${uk.attrname}<#assign idx=idx+1><#if (idx<uks[key]?size)>,</#if></#list>){
                 return BeanUtils.copy(${table.classname}Dao.getBy${key}(<#assign idx=0><#list uks[key] as uk> ${uk.attrname}s<#assign idx=idx+1><#if (idx<uks[key]?size)>,</#if></#list>));
        }

        @Override
        public List<${table.className}Dto> listBy${key}s(<#assign idx=0><#list uks[key] as uk>List<${uk.attrType}> ${uk.attrname}s<#assign idx=idx+1><#if (idx<uks[key]?size)>,</#if></#list>){
                return BeanUtils.copyList(${table.classname}Dao.listBy${key}s(<#assign idx=0><#list uks[key] as uk> ${uk.attrname}s<#assign idx=idx+1><#if (idx<uks[key]?size)>,</#if></#list>));
        }

    </#list>

}
