package cn.com.duiba.mysql.generator.gencode;

import cn.com.duiba.mysql.generator.entity.GeneratorConfig;
import cn.com.duiba.mysql.generator.entity.TableEntity;
import cn.com.duiba.mysql.generator.service.DuibaFreemarkerService;

public class SQLXmlGenerator extends AbstractGenerator{

	public SQLXmlGenerator(DuibaFreemarkerService freemarkerService, TableEntity tableEntity, GeneratorConfig config) {
		super(freemarkerService, tableEntity, config);
	}

	@Override
	public String getFTL() {
		return "sql_xml";
	}

	@Override
	public String genFileName() {
		return tableEntity.getClassName() + "Mapper.xml";
	}

	@Override
	protected String genFilePath() {
		return config.getXmlLocation();
	}
}
