package cn.com.duiba.mysql.generator.gencode;

import cn.com.duiba.mysql.generator.entity.GeneratorConfig;
import cn.com.duiba.mysql.generator.entity.TableEntity;
import cn.com.duiba.mysql.generator.service.DuibaFreemarkerService;
import cn.com.duiba.mysql.generator.utils.PathUtils;

/**
 * @author sunchangji
 */
public class JavaDtoGenerator extends AbstractGenerator{


    public JavaDtoGenerator(DuibaFreemarkerService freemarkerService, TableEntity tableEntity, GeneratorConfig config){
        super(freemarkerService,tableEntity, config);
    }

    @Override
    public String getFTL() {
        return "java_dto";
    }

    @Override
    public String genFileName() {
        return tableEntity.getClassName() + "Dto.java";
    }

    @Override
    protected String genFilePath() {
        return PathUtils.getPathByPackage(config.getDtoPackage(), config);
    }
}
