package cn.com.duiba.mysql.generator;

import cn.com.duiba.mysql.generator.entity.GeneratorConfig;
import cn.com.duiba.mysql.generator.entity.TableEntity;
import cn.com.duiba.mysql.generator.exceptions.DuibaGeneratorException;
import cn.com.duiba.mysql.generator.gencode.JavaDaoGenerator;
import cn.com.duiba.mysql.generator.gencode.JavaDaoImplGenerator;
import cn.com.duiba.mysql.generator.gencode.JavaDtoGenerator;
import cn.com.duiba.mysql.generator.gencode.JavaEntityGenerator;
import cn.com.duiba.mysql.generator.gencode.JavaRemoteServiceInterfaceGenerator;
import cn.com.duiba.mysql.generator.gencode.JavaRemoteServiceInterfaceImplGenerator;
import cn.com.duiba.mysql.generator.gencode.JavaServiceInterfaceGenerator;
import cn.com.duiba.mysql.generator.gencode.JavaServiceInterfaceImplGenerator;
import cn.com.duiba.mysql.generator.gencode.JavaVoGenerator;
import cn.com.duiba.mysql.generator.gencode.SQLXmlGenerator;
import cn.com.duiba.mysql.generator.service.DuibaFreemarkerService;
import cn.com.duiba.mysql.generator.utils.DBUtils;
import org.apache.commons.lang.StringUtils;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

/**
 * 代码生成器
 * @author sunchangji
 */
public class MybatisGenerator {

    /**
     * 代码生成器主类
     *
     * @return
     */
    public static void genCode(GeneratorConfig config) {
        check(config);

        DuibaFreemarkerService freemarkerService = new DuibaFreemarkerService();
        TableEntity tableEntity = null;
        try {
            tableEntity = DBUtils.getTableInfo(config);
        } catch (SQLException e) {
            throw new DuibaGeneratorException(e);
        }
        //生成entity文件
        if(StringUtils.isNotBlank(config.getEntityPackage())) {
            JavaEntityGenerator doGenerator = new JavaEntityGenerator(freemarkerService, tableEntity, config);
            doGenerator.gen();
        }
        //生成dao文件
        if(StringUtils.isNotBlank(config.getDaoPackage())) {
            JavaDaoGenerator daoGenerator = new JavaDaoGenerator(freemarkerService, tableEntity, config);
            daoGenerator.gen();
        }
        //生成daoImpl文件
        if(StringUtils.isNotBlank(config.getDaoPackage())) {
            JavaDaoImplGenerator daoImplGenerator = new JavaDaoImplGenerator(freemarkerService, tableEntity, config);
            daoImplGenerator.gen();
        }
        //生成remote接口文件
        if(StringUtils.isNotBlank(config.getRemoteImplLocation())) {
            JavaRemoteServiceInterfaceImplGenerator remoteImplGenerator = new JavaRemoteServiceInterfaceImplGenerator(freemarkerService, tableEntity, config);
            remoteImplGenerator.gen();
        }
        //生成Service接口文件
        if(StringUtils.isNotBlank(config.getServiceLocation())) {
            JavaServiceInterfaceGenerator serviceInterfaceGenerator = new JavaServiceInterfaceGenerator(freemarkerService, tableEntity, config);
            serviceInterfaceGenerator.gen();
        }
        //生成ServiceImpl接口文件
        if(StringUtils.isNotBlank(config.getServiceImplLocation())) {
            JavaServiceInterfaceImplGenerator serviceImplGenerator = new JavaServiceInterfaceImplGenerator(freemarkerService, tableEntity, config);
            serviceImplGenerator.gen();
        }
        //生成web层-Controller接口文件
//        JavaControllerImplGenerator controllerGenerator = new JavaControllerImplGenerator(freemarkerService, tableEntity, config);
//        controllerGenerator.gen();
        //生成web层-Vo接口文件
        if(StringUtils.isNotBlank(config.getVoLocation())){
            JavaVoGenerator voImplGenerator = new JavaVoGenerator(freemarkerService, tableEntity, config);
            voImplGenerator.gen();
        }
        //生成xml文件
        if(StringUtils.isNotBlank(config.getXmlLocation())){
            SQLXmlGenerator sqlXmlGenerator = new SQLXmlGenerator(freemarkerService, tableEntity, config);
            sqlXmlGenerator.gen();
        }
        if(StringUtils.isNotBlank(config.getApiModuleName())){
            config.setModuleName(config.getApiModuleName());
        }
        //生成dto文件
        if(StringUtils.isNotBlank(config.getDtoPackage())) {
            JavaDtoGenerator dtoGenerator = new JavaDtoGenerator(freemarkerService, tableEntity, config);
            dtoGenerator.gen();
        }
        //生成remoteImpl接口文件
        if(StringUtils.isNotBlank(config.getRemotePackage())) {
            JavaRemoteServiceInterfaceGenerator remoteInterfaceGenerator = new JavaRemoteServiceInterfaceGenerator(freemarkerService, tableEntity, config);
            remoteInterfaceGenerator.gen();
        }

    }

    private static void check(GeneratorConfig config) {
        if (config == null){
            throw new DuibaGeneratorException("生成代码前请设置");
        }

        config.check();
    }

    public static Connection getConnection(String url, String user, String pwd){
        Connection connection = null;
        try {
            Class.forName("com.mysql.jdbc.Driver");
            connection = DriverManager.getConnection(url, user,pwd);
        } catch (ClassNotFoundException | SQLException e) {
            throw new DuibaGeneratorException(e);
        }
        return connection;
    }
}
