package cn.com.duiba.mysql.generator.gencode;

import cn.com.duiba.mysql.generator.entity.GeneratorConfig;
import cn.com.duiba.mysql.generator.entity.TableEntity;
import cn.com.duiba.mysql.generator.service.DuibaFreemarkerService;
import cn.com.duiba.mysql.generator.utils.PathUtils;

public class JavaServiceInterfaceImplGenerator extends AbstractGenerator{

	public JavaServiceInterfaceImplGenerator(DuibaFreemarkerService freemarkerService, TableEntity tableEntity, GeneratorConfig config) {
		super(freemarkerService, tableEntity, config);
	}

	@Override
	public String getFTL() {
		return "java_service.impl";
	}

	@Override
	public String genFileName() {
		return tableEntity.getClassName() + "ServiceImpl.java";
	}

	@Override
	protected String genFilePath() {
		return PathUtils.getPathByPackage(config.getServiceImplLocation(), config);
	}
}
