# duiba根据数据库表自动生成代码
- 该工具根据数据库表名一键生成Entity、Dao、DaoImpl、mapper.xml文件，生成的文件直接存入当前工程指定的包下，目前只支持MySQL
- 实现上并没有集成MyBatis Generator，而是采用Freemarker生成代码，更加轻量，更容易定制SQL语句和命名风格
- 使用工具的价值在于减少人为工作量，统一代码风格

##使用方式
1.首先根目录build.gradle文件中引入
```
dependency("cn.com.duiba:mysql-generator:0.1.0")
```
2.在biz模块中引入
```
testCompile("cn.com.duiba:mysql-generator")
```
在test目录下新建CodeGeneratorTest.java，代码如下
```java
public class MysqlGeneratorTest {

	private static final String DB_URL_TPL = "jdbc:mysql://dev.config.duibar.com:3306/{0}?createDatabaseIfNotExist=true&useUnicode=true&characterEncoding=UTF-8&zeroDateTimeBehavior=convertToNull&allowMultiQueries=true&connectTimeout=5000&socketTimeout=60000";

	/**
	 * 库名
	 */
	private static final String TABLE_SCHEMA = "act_com_conf";

	/**
	 * 表名
	 */
	private static final String TABLE_NAME = "tb_duiba_brick_config";

	/**
	 * 数据库账户
	 */
	private static final String USER = "dev";

	/**
	 * 数据库密码
	 */
	private static final String PWD = "dev_fas015";

	@Test
	public void createCode(){
		String DB_URL = MessageFormat.format(DB_URL_TPL,TABLE_SCHEMA);
		GeneratorConfig config = new GeneratorConfig(DB_URL, USER, PWD);
		//生成dao代码位置
		config.setDaoPackage("cn.com.duiba.test.dao");
		//生成entity代码位置
		config.setEntityPackage("cn.com.duiba.test.entity");
		//mapper.xml文件位置
		config.setXmlLocation("src/main/resources/mybatis/test");
		//数据库名
		config.setTableSchema(TABLE_SCHEMA);
		//表名
		config.setTableName(TABLE_NAME);
		//表前缀,设置该值后生成的Entity,dao,daoImpl类不会以tb开头
		config.setTablePrefix("tb");
		//设置生成的java文件存放的模块名,如果该代码执行和生成的代码在一个模块下则不需要设置,
		//比如该执行代码在activity-center-deploy模块下,需要生成的entity,dao，daoImpl需要在activity-center-biz模块下,则需要设置ModuleName的值为activity-center-biz
		//如果该执行代码在activity-center-biz下,并且生成的代码也在activity-center-biz下则不需要设置ModuleName的值
		config.setModuleName("");

		MybatisGenerator.genCode(config);
	}
}

```