import React, { useState } from "react";
import { useDebugPosition } from "./hook";
import { RES_PATH } from "../../../../sparkrc";
import { noUrl } from "@src/utils/share";
import { opfStatisticSdkClick } from "@src/store/opfStatisticSdk";
import store from "@src/store";
import { useThrottle } from "@src/utils/utils";
import { handleLogClick } from '../../../../MD';
import "./index.less";

const FloatingIcon = () => {
  const [show, setShow] = useState(true);
  const { x, y, onFloatTouchEnd, onFloatTouchMove, onFloatTouchStart } = useDebugPosition("#floatingIcon");

  const handleClick = useThrottle(async (e) => {
    handleLogClick(1, 3);
    e.stopPropagation();
    const { floatingInfo } = store.frontVariable;
    if (noUrl(floatingInfo)) return;
    await store.appAuth(() => {
      opfStatisticSdkClick(`floating-icon`, `${floatingInfo.remark}浮窗按钮`);
      setTimeout(() => store.jumpLink(floatingInfo));
    });
  }, 1000);

  const handleClose = (e) => {
    e.stopPropagation();
    setShow(false);
  };

  if (!show) return null;

  return (
    <div
      id="floatingIcon"
      className="floating"
      style={{
        top: y,
        left: x,
        transition: "width left 0.5s ease-in-out",
        touchAction: "none",
      }}
      onTouchStartCapture={onFloatTouchStart}
      onTouchMoveCapture={onFloatTouchMove}
      onTouchEndCapture={onFloatTouchEnd}>
      <div className="icon-box">
        <img onClick={handleClick} className="fuChuang" src={RES_PATH + "首页/浮窗.png"} alt="" />
        <img onClick={handleClose} className="closeBtn" src={RES_PATH + "首页/close.png"} alt="" />
      </div>
    </div>
  );
};

export default FloatingIcon;
