import { isWeChat, onUpdateShare } from '@src/utils/share';
import store from '.';
import modalStore from './modal';
import { makeAutoObservable } from 'mobx';
import { appShare } from '@src/AppTool';
import { windowJumpUrl } from '@src/utils/utils';


const shareStore = makeAutoObservable({

  /** app落地页-二次分享初始化 */
  async initSharePageShare () {
    // 分享信息
    const { title, content, thumbnail, url} = store.frontVariable?.shareInfo || {};
    const params = {
      title: title, // 标题
      content: content, // 描述
      thumbnail: thumbnail, // 图片
      url: url // 链接
    };
    onUpdateShare(params);
  },

  /**
   * 分享
   * isInit 是否初始化分享，默认不初始化
   */
  async doShare () {
    // 分享信息
    const { title, content, thumbnail, url } = store.frontVariable?.shareInfo || {};
    const params = {
      title:  title, // 标题
      content: content, // 描述
      thumbnail: thumbnail, // 图片
      url: url // 链接
    };
    if (isWeChat()) {
      modalStore.pushPop("ShareGuidePop");
      onUpdateShare(params);
    } else {
      // appMultiShareTools(params);
      appShare(params);
    }
  },

  /** 唤端 */
  toApp (page = 'home') {
    const linkObj = store.frontVariable?.shareToAppLink;
    const link = linkObj[page]; // { home, sub1, sub2, sub3, sub4, sub5, sub6 }
    console.log('link', link);
    windowJumpUrl(link);
  }
});

export default shareStore;
