import { useCallback, useEffect, useRef, useState } from "react";

export function useDebugPosition(id) {
  const floatRef = useRef();
  const [showFloat, setShowFloat] = useState(true);
  const [position, setPosition] = useState({
    x: 317,
    y: 327
  });

  const onFloatTouchStart = useCallback(() => {
    setShowFloat(false);
  }, []);

  const onFloatTouchMove = useCallback((e) => {
    const { clientX, clientY } = e.touches[0];
    const { clientWidth, clientHeight } = document.body;
    let x = clientX;
    let y = clientY;

    // 设置边界值
    const b_x = clientWidth - 64;
    const b_y = clientHeight - 64;

    if (x < 0) x = 0;
    if (x > b_x) x = b_x;
    if (y < 0) y = 0;
    if (y > b_y) y = b_y;

    setPosition({
      x,
      y,
    });
  }, []);

  const onFloatTouchEnd = useCallback(() => {
    setShowFloat(true);
  }, []);

  useEffect(() => {
    floatRef.current = document.getElementById(id);
  }, [id]);

  return {
    x: position.x,
    y: position.y,
    showFloat,
    onFloatTouchStart,
    onFloatTouchMove,
    onFloatTouchEnd,
  };
}
