import MD from "spark-utils/out/md/index.js";
import { logClick } from "@spark/utils/src-js/md";
import { jsonp } from "@spark/api-base";
import store from "@src/store";
import { isWeChat } from "@src/utils/share";

const appId = CFG.appID;
const dcm = "202." + CFG.projectId + ".0.0";
const domain = "";

const MDList = [
  {
    ele: `.test-md1`,
    data: {
      dpm: `${appId}.110.5.1`,
      dcm,
      domain,
      appId
    },
    once: false
  }
];

export default () =>
  MD({
    show: MDList, // 曝光
    click: MDList, // 点击
  });

export function logExposure (params) {
  jsonp("/exposure/standard", params);
}

export function handleLogExposure (id, id2, dom_c = 0, dom_d = 0) {
  logExposure({
    dpm: `${appId}.110.${id}.${id2}`,
    dcm,
    domain,
    appId,
    dom: store.userInfo?.ibknum + `.${isWeChat() ? "微信" : "手机银行app"}.${dom_c}.${dom_d}`
  });

}

// 导出一个函数handleLogClick，用于处理日志点击事件
export function handleLogClick (id, id2, dom_c = 0, dom_d = 0) {
  // 调用logClick函数，传入参数dpm、dcm、domain、appId
  logClick({
    dpm: `${appId}.110.${id}.${id2}`,
    dcm,
    domain,
    appId,
    dom: store.userInfo?.ibknum + `.${isWeChat() ? "微信" : "手机银行app"}.${dom_c}.${dom_d}`
  });
}
