import { PAGE_MAP } from "@src/utils/constants";
import { makeAutoObservable } from "mobx";
import API from "../api/index";
import { GetCurrSkinId, getCustomShareId, windowJumpUrl } from "@src/utils/utils";
import { Toast } from "@spark/ui";
import { isWeChat } from "@src/utils/share";
import { appJump, getBranchId } from "@src/AppTool";
import { opfStatisticSdkInit } from "./opfStatisticSdk";

const skinId = GetCurrSkinId() || getCustomShareId();

const store = makeAutoObservable({
  /** 活动规则 */
  ruleInfo: "",

  /** 前端开发配置 */
  frontVariable: {},

  /** 当前页面 */
  curPage:
    {
      // TODO 举例子，自定义页面，因为mng更新原因原数字id会对应一个新的字符串id
      5055: "sharePage",
      Did1NDA0NDc: "sharePage",

      myPrize: "myPrize", // TODO 举例子 新宿台奖品页
      index: PAGE_MAP.HOME_PAGE,
    }[skinId] || PAGE_MAP.HOME_PAGE,

  pageData: {},

  /** 场景切换 */
  changePage(page, data = {}) {
    this.pageData = data;
    this.curPage = page;
  },

  /** 获取活动规则 */
  async initRule() {
    // 模拟获取远程的数据
    const { data } = await API.getRule();
    this.ruleInfo = data;
  },

  /** 获取前端配置项 */
  async getFrontVariable() {
    // 获取前端开发配置
    const { data } = await API.getFrontVariable();
    console.info("前端开发配置", data);
    this.frontVariable = data
      ? {
          ...data,
          shareInfo: JSON.parse(data?.shareInfo || "{}"),
          floatingInfo: JSON.parse(data?.floatingInfo || "{}"),
        }
      : {};
  },

  /** 用户信息 */
  userInfo: {},

  /** 获取用户信息 */
  async getUserInfo() {
    const { success, data } = await API.getUserInfo();
    if (success) {
      this.userInfo = data || {};
      sessionStorage.setItem("openid", data?.openid);
      sessionStorage.setItem("unionid", data?.unionid);
    }
  },

  /** 初始化埋点 */
  async initStatistic() {
    if (!isWeChat()) return;
    opfStatisticSdkInit({
      openid: sessionStorage.getItem("openid") || store.userInfo?.openid,
      unionid: sessionStorage.getItem("unionid") || store.userInfo?.unionid,
    });
  },

  /** 首页 */
  homeInfo: {},
  /** 获取首页信息 */
  async fetchHomeInfo() {
    const { success, data } = await API.homeInfo();
    if (success) {
      this.homeInfo = data;
      // console.info("首页信息", data);
    }
  },

  /** app授权客户信息 */
  async appAuth(callback) {
    // 微信端直接跳转 不需要授权
    if (isWeChat()) return callback();
    // 有客户信息直接跳转 不需要授权
    // if (store.userInfo?.customerId) return callback();

    const branchData = await getBranchId();
    console.info("app授权", branchData);
    const splitBranchParams = JSON.parse(branchData.cipherText || "{}");
    if (splitBranchParams && splitBranchParams?.hmaCipherText) {
      await API.appAuth({
        body: splitBranchParams.body,
        hmaCipherText: splitBranchParams.hmaCipherText,
        hmac: splitBranchParams.hmac,
        skey: splitBranchParams.skey,
      });
      await store.getUserInfo();
      callback && callback();
    }
  },

  /** 判断活动状态 */
  judgeActivity() {
    const { actStartTime, actEndTime, systemTime } = store?.homeInfo || {};
    if (systemTime < actStartTime) {
      Toast("活动未开始");
      return false;
    } else if (systemTime >= actEndTime) {
      Toast("活动已结束");
      return false;
    }

    return true;
  },

  /** 跳转方法 */
  jumpLink(item) {
    if (!item?.wxUrl && !item?.appUrl) {
      Toast("活动暂未上线，敬请期待~");
      return;
    }
    if (isWeChat()) {
      if (item.wxUrl) {
        windowJumpUrl(item.wxUrl);
      } else {
        Toast("前往APP活动参与~");
      }
    } else {
      if (item.appUrl) {
        appJump(item.appUrl);
      } else {
        Toast("暂未开放~");
      }
    }
  },
});

export default store;
