const rule = require("./common/rule");
const drawNum = require("./common/drawNum");
const coopFrontVariable = require("./common/coopFrontVariable");
const {AESEncrypt} = require("./Crypto");
const homeInfo = require("./common/homeInfo");
const userInfo = require("./common/userInfo");

const proxy = {
  ...require("./project"),
  "GET /projectRule.query": rule,
  "GET /drawNum.query": drawNum,
  "GET /coop_frontVariable.query": coopFrontVariable,

  "GET /spring/start.do": {
    "code": "code",
    "success": true,
    "message": "message",
    "timeStamp": Date.now(),
    "data": AESEncrypt(JSON.stringify({
      "startId": "officia",
      "countDown": 30
    }), "1696BD3E5BB915A0", "cDOiBC1n2QrkAY2P"),
  },
  "GET /activity/index.do": homeInfo,
  "GET /activity/userInfo.do": userInfo,
};
module.exports = proxy;
