"use strict";

import React from "react";
import { observer } from "mobx-react";
import "./rulepop.less";
import { _asyncThrottle } from "@src/utils/utils";
import store from "@src/store";
import modalStore from "@src/store/modal";
import { opfStatisticSdkClick } from "@src/store/opfStatisticSdk";
import { RES_PATH } from "../../../sparkrc";
import { noUrl } from "@src/utils/share";
import { Toast } from "@spark/ui";
import { handleLogClick, handleLogExposure } from '../../../MD';

@observer
class Rulepop extends React.Component {
  constructor(props) {
    super(props);
  }

  componentDidMount () {
    const { item } = this.props.popData || {};
    // 分会场活动弹窗曝光
    handleLogExposure(1, 4, `${item.remark}分会场`);
    const { rule } = item || {};
    const [rule1, rule2] = rule?.split("######") || [rule, ""];
    // 分会场活动弹窗-参与按钮曝光
    rule1 && handleLogExposure(1, 5, `${item.remark}分会场`);
    rule2 && handleLogExposure(1, 5, `${item.remark}分会场`, 1);
  }

  // 只有规则弹窗这块需要特殊处理一下有两个跳转地址的情况
  handleDetail = _asyncThrottle(async (type = 1) => {
    const { item } = this.props.popData || {};
    const [wxUrl1, wxUrl2] = item?.wxUrl?.split?.(",") || [];
    const [appUrl1, appUrl2] = item?.appUrl?.split?.(",") || [];
    opfStatisticSdkClick(`detail-btn-${item.id}`, `${item.remark}弹窗按钮${type === 2 ? "2" : ""}`);
    handleLogClick(1, 5, `${item.remark}分会场`, type === 1 ? 0 : 1);

    const wxUrl = type === 1 ? wxUrl1 : wxUrl2;
    const appUrl = type === 1 ? appUrl1 : appUrl2;

    if (noUrl({ wxUrl, appUrl })) {
      Toast("暂未开始抽奖");
      return;
    }

    setTimeout(() =>
      store.jumpLink({
        wxUrl,
        appUrl,
      })
    );
  });

  handleClose = () => {
    modalStore.closePop();
  };

  render () {
    const { item } = this.props.popData || {};
    const { rule, popbuttonImg } = item || {};
    const [rule1, rule2] = rule?.split("######") || [rule, ""];
    const [wxUrl1, wxUrl2] = item?.wxUrl?.split?.(",") || [];
    const [appUrl1, appUrl2] = item?.appUrl?.split?.(",") || [];

    return (
      <div className="rulepop modal_center">
        <span className="close_btn" onClick={this.handleClose}></span>
        <span className={`beiJing ${rule2 ? "two" : ""}`}></span>
        {rule2 ? (
          <>
            <span
              className="btn anNiu1"
              style={{
                backgroundImage: `url(${popbuttonImg || RES_PATH + "rulePop/按钮1.png"})`,
                filter: `grayscale(${noUrl({ wxUrl: wxUrl1, appUrl: appUrl1 }) ? "100%" : "0"})`,
              }}
              onClick={() => this.handleDetail(1)}></span>
            <span
              className="btn anNiu2"
              style={{
                backgroundImage: `url(${popbuttonImg || RES_PATH + "rulePop/按钮2.png"})`,
                filter: `grayscale(${noUrl({ wxUrl: wxUrl2, appUrl: appUrl2 }) ? "100%" : "0"})`,
              }}
              onClick={() => this.handleDetail(2)}></span>
            <span className="txt ruleInfo1" dangerouslySetInnerHTML={{ __html: rule1 }}></span>
            <span className="txt ruleInfo2" dangerouslySetInnerHTML={{ __html: rule2 }}></span>
          </>
        ) : (
          <>
            <span
              className="btn anNiu"
              style={{
                backgroundImage: `url(${popbuttonImg || RES_PATH + "rulePop/按钮1.png"})`,
                filter: `grayscale(${noUrl({ wxUrl: wxUrl1, appUrl: appUrl1 }) ? "100%" : "0"})`,
              }}
              onClick={() => this.handleDetail(1)}></span>
            <span className="txt ruleInfo" dangerouslySetInnerHTML={{ __html: rule1 }}></span>
          </>
        )}
      </div>
    );
  }
}

export default Rulepop;
