"use strict";
import React from "react";
import { observer } from "mobx-react";
import { _asyncThrottle } from "@src/utils/utils";
import store from "@src/store";
import shareStore from "@src/store/share";
import modalStore from "@src/store/modal";
import { opfStatisticSdkClick } from "@src/store/opfStatisticSdk";
import { noUrl } from "@src/utils/share";
import { RES_PATH } from "../../../sparkrc.js";
import "./index.less";
import { handleLogClick, handleLogExposure } from "../../../MD";
import { Toast } from "@spark/ui";

@observer
class ShouYe extends React.Component {
  constructor(props) {
    super(props);
  }

  async componentDidMount() {
    // 获取首页信息
    await store.fetchHomeInfo();
    // 获取用户信息
    await store.getUserInfo();
    // 埋点注册
    await store.initStatistic();
    // 首页曝光埋点
    handleLogExposure(1, 1);
    // 首页-分享按钮
    handleLogExposure(1, 2);
    // 首页-分会场活动按钮曝光
    store?.homeInfo?.activityInfo?.map((act, index) => {
      handleLogExposure(1, 3, `${index + 1}_${act.remark}分会场入口按钮`);
    });
  }

  handleClickJump = _asyncThrottle(async (item, index) => {
    await store.appAuth(() => {
      handleLogClick(1, 3, `${index + 1}_${item.remark}分会场入口按钮`);
      opfStatisticSdkClick(`join-btn-${index + 1}`, `${item.remark}分会场入口按钮`);

      // 如果没有规则内容，直接跳转
      const { rule, wxUrl, appUrl } = item;
      if (!rule) {
        if (noUrl({ wxUrl, appUrl })) {
          Toast("活动暂未开始");
        } else {
          setTimeout(() => store.jumpLink(item));
        }
        return;
      }
      // 有规则内容，显示弹窗
      setTimeout(() => modalStore.pushPop("RulePop", { item }));
    });
  }, 500);

  // handleClickBanner = _asyncThrottle(async (item, index) => {
  //   if (noUrl(item)) return;
  //   await store.appAuth(() => {
  //     handleLogClick(1, 2, `第${index + 1}个banner`);
  //     opfStatisticSdkClick(`banner-${index + 1}`, `第${index + 1}个banner`);
  //     setTimeout(() => store.jumpLink(item));
  //   });
  // }, 500);

  handleClickShare = _asyncThrottle(async () => {
    handleLogClick(1, 2);
    shareStore.doShare();
  }, 1000);

  render() {
    const { activityInfo = [] } = store.homeInfo;
    const { pageBgImg } = store.frontVariable;

    return (
      <div className="shouYe">
        <img className="beiJing" src={pageBgImg || RES_PATH + "首页/背景.png"} alt="bg" />
        <div className="activityInfo">
          {activityInfo?.map((item, index) => (
            <span
              key={"activity_" + index}
              className={`item item_${index}`}
              onClick={() => this.handleClickJump(item, index)}>
              <img src={item.buttonImg} alt="" />
            </span>
          ))}
        </div>
        {/* <div className="bannerInfo">
          {bannerInfo?.map((banner, index) => (
            <span
              key={"banner_" + index}
              className={`banner banner_${index}`}
              onClick={() => this.handleClickBanner(banner, index)}>
              <img src={banner.bannerImg} alt="" />
            </span>
          ))}
        </div> */}
        <span className="share" onClick={this.handleClickShare}></span>

        {/* <FloatingIcon /> */}
      </div>
    );
  }
}

export default ShouYe;
