import { isWeChat } from "@src/utils/share";
let isInit = false;
export const opfStatisticSdkInit = (opt) => {

  if (!isWeChat()) return;

  if (isInit) return;

  try {
    opfStatisticSdk?.init(
      {
        pfid: CFG.opfStatisticSdk_pfid, // （必须）CDMS 系统分配的平台 id，正式服 pfid：be_2zFRQQ2Fb
        appid: CFG.opfStatisticSdk_appid, // （必须，1-50 位，数字，大小写字母，下划线，短横线）场景载体id，一般指作品 id
        apptype: "xapp", // （必须）应用类型，外部导入作品均为 xapp
        mpid: "wx567af860fd4db040", // （非必须参数，如果有微信授权，则必须填入）微信公众号 appid
        openid: "", // （非必须参数，如果有微信授权，则必须填入）微信公众号获取的用户 openid
        unionid: "", // （非必须参数，如果有微信授权且有 unionid，则必须填入）微信公众号获取的用户 unionid
        userInfo: {}, // （非必须，如果有微信授权并能拿到用户信息，则必须填入）微信公众号网页授权获取的用户信息 JSON 对象
        appUid: "", // (非必须)中行 app 用户标识
        phone: "", // (非必须)用户手机号码
        closeSdkAutoExit: false, // 需要由 SDK 自行判断上报退出事件时机时，传false，建议传 false
        pageName: "", // (当初始化时 document.title 为空时必传)传入非空值时将用作page_name 的值，取代 document.title 的值
        ...opt
      },
      {
        // sdkUrl: location.href.indexOf("test") > -1 ? "https://activity.m.duiba.com.cn/83591boclog/test/real-time/" : "https://activity.m.duiba.com.cn/83591boclog/prod/real-time/"
        sdkUrl: `${location.origin}/real-time/`
        // audidUrl: "https://xxx.xxx.xxx/unlogin/app/post_rabbitpre", // 正式服获取营销系统客户档案 id 接口地址，以实际使用为准(按照代理配置填写)
      }
    );
  } catch (e) {
    console.error("maidian", e);
  }

  isInit = true;
};

export const opfStatisticSdkClick = (id, btnName) => {
  if (!isWeChat()) return;
  opfStatisticSdk.btnClick(id, btnName);
};
