/**
 * 获取cookie的值
 * @param {*} cookieName
 */
function getCookie(cookieName) {
  const strCookie = document.cookie;
  const arrCookie = strCookie.split("; ");
  for (let i = 0; i < arrCookie.length; i++) {
    const arr = arrCookie[i].split("=");
    if (cookieName == arr[0]) {
      return arr[1];
    }
  }
  return "";
}

// 跳转苏银豆商城
export const onToAppMall = () => {
  appJump("jfsc");
};
// 行方跳转
export function appJump(url, needlogin = "1") {
  console.info('appJump url===> ', url);
  if (!!!url) return;
  cookieSetInSession();

  const ThirdApp = window["ThirdApp"];
  if (url.slice(0, 4) == "http") {
    // http开头
    ThirdApp && ThirdApp.loadUrlNewJSMB(url, "1", "1", "", needlogin, "1");
  } else if (url.slice(0, 4) == "page") {
    // 客户端
    ThirdApp && ThirdApp.loadUrlNewJSMB(url, "1", "1", "", needlogin, "0");
  } else {
    // 第三方
    ThirdApp && ThirdApp.loadUrlNewJSMB(url, "3", "1", "", needlogin, "0");
  }

  cookieSetBack();

  window.setTimeout(() => {
    cookieSetBack();
  }, 1000);
}

export function cookieSetInSession() {
  if (getCookie("tokenId") != "") {
    console.info("cooke保存有tokenid");
    console.info(document.cookie, "cookie");
    const ThirdApp = window["ThirdApp"];
    ThirdApp &&
      ThirdApp.setSession("final", {
        tokenId: getCookie("tokenId"),
        wdata3: getCookie("wdata3"),
        wdata4: getCookie("wdata4"),
        createdAtToday: getCookie("createdAtToday"),
        isNotLoginUser: getCookie("isNotLoginUser"),
        dcustom: getCookie("dcustom"),
      });
  }
}

export function cookieSetBack() {
  return new Promise((resolve, reject) => {
    const ThirdApp = window["ThirdApp"];
    ThirdApp && ThirdApp.getSession("final", function (data) {
      console.info("getsessionFinal", data);
      Object.keys(data).forEach((key) => {
        document.cookie = String(key) + "=" + data[key];
      });
      resolve(data);
    });
    setTimeout(() => {
      resolve({});
    }, 5000);
  });
}

/**
 * @description 把图片保存到相册<br>
 * @param {string}
 *         data 图片base64
 *
 */
export function saveDCPic(data) {
  // console.info('saveDCPic data', data)
  const ThirdApp = window["ThirdApp"];
  try {
    var cfg = {
      base64: data,
    };
    ThirdApp && ThirdApp._callHandler("saveDCPic", JSON.stringify(cfg));
  } catch (e) {
    console.info("saveDCPic error", e);
    ThirdApp && ThirdApp.alertinfo("把图片保存到相册异常", "saveDCPic:" + e);
  }
}

// 分享海报
export function wxShareImg(url) {
  const ThirdApp = window["ThirdApp"];
  if (ThirdApp?.versionFiveFlag) {
    try {
      // 获取回调函数方法名
      const cfg = {
        type: "WX,PYQ", // 分享渠道
        // WX-微信，PYQ-朋友圈，QQ-qq，WB-微博，DX-短信，YX-邮箱
        title: "江苏银行活动分享图片", // 分享标题
        content: "分享图片", // 分享摘要
        hrefUrl: "", // 分享url地址
        // imgUrl:"https://yun.duiba.com.cn/aurora/assets/ac9954f26c6877b9ebf8d53ead7935f0e9f9e850.png", // 分享图片url地址
        callback: "", // 回调函数
        shareType: "Image", // 分享类型：Image代表图片形式分享  WebPage代表网页形式
        picBase64: url,
      };
      ThirdApp._callHandler("sharePages", JSON.stringify(cfg));
    } catch (e) {
      ThirdApp.alertinfo("页面分享异常", "sharePages:" + e);
    }
  } else {
    if (ThirdApp?.os == "android") {
      window["SysClientJs"].shareWeb("", "", url);
    } else if (ThirdApp?.os == "iphone") {
      try {
        const data = {
          picBase64: url,
        };
        window["_WK_DATAS"]["shareWeb"] = data;
        window["setWebitEvent"]("_shareWeb()", "D20");
      } catch (e) {
        console.info(e);
      }
    }
  }
}
