import Panel from "../../Module/Panel";
import { _decorator, Button, Label } from "cc";
import { getWebData, LOG_TYPE, sendLog, sendWebNet, sendWebNetWithToken, WebNetName } from "../Utils/WebNet/WebNet";
import { showToast } from "../../Module/UIFast";


const { ccclass, property } = _decorator;

@ccclass('ToolBuyConfirmPanel')
export default class ToolBuyConfirmPanel extends Panel {

    static skin = "ToolBuyConfirmPanel";
    static group = "ToolBuyConfirmPanel";


    async start() {
        const { data } = getWebData(WebNetName.index) || {}
        // 购买天降财神道具所需苏银豆
        const { buyRichSpSyd = 0 } = data
        this.view["buyTip"].getComponent(Label).string = `确认使用${buyRichSpSyd}苏银豆购买\n天降财神道具*1 吗`;
        
        this.view["close"].on(Button.EventType.CLICK, this.hidePanel, this);
        this.view["confirmBtn"].on(Button.EventType.CLICK, this.buyHandle, this);
        this.view["cancelBtn"].on(Button.EventType.CLICK, () => {
            sendLog(LOG_TYPE.CLICK, 39)
            this.hidePanel()
        }, this);
        sendLog(LOG_TYPE.EXPOSURE, 39)
        sendLog(LOG_TYPE.EXPOSURE, 40)
    }

    /** 确认购买 */
    async buyHandle() {
        sendLog(LOG_TYPE.CLICK, 40)
        const res = await sendWebNetWithToken(WebNetName.buyRichSp);
        if (res?.success) {
            showToast("购买成功～快去使用吧")
            this.hidePanel()
        }
    }

}
