import Panel from "../../Module/Panel";
import { _decorator, Button, Label, Node } from "cc";
import { changeScene } from "db://assets/Module/UIFast";
import { HomeScene } from "db://assets/Scripts/Scenes/HomeScene";
import { LOG_TYPE, sendLog } from "../Utils/WebNet/WebNet";

const {ccclass, property} = _decorator;

@ccclass('NoPrizePanel')
export default class NoPrizePanel extends Panel {

    static bundle: string = "";
    static skin = "NoPrizePanel";
    static group = "NoPrizePanel";

    @property(Node)
    close: Node = null!;

    @property(Node)
    cancel: Node = null!;

    async start() {
        sendLog(LOG_TYPE.EXPOSURE, 28)
        this.close.on(Button.EventType.CLICK, this.onClose, this);
        this.cancel.on(Button.EventType.CLICK, this.onClose, this);
    }

    /**
     * 返回首页
     */
    onClose = () => {
        sendLog(LOG_TYPE.CLICK, 28);
        changeScene(HomeScene);
        this.hidePanel();
    }

}
